<?php
/**
 * Welcome template.
 *
 * @package woodmart
 */

?>

<div class="xts-wizard-content-inner xts-wizard-welcome">

	<div class="xts-wizard-logo">
		<img class="xts-wizard-logo" src="<?php echo esc_url( $this->get_image_url( 'logo.svg' ) ); ?>" alt="logo">
		</div>

	<h3>
		<?php esc_html_e( 'Thank you for choosing our theme!', 'woodmart' ); ?>
	</h3>

	<p>
		<?php
		esc_html_e(
			'در بخش نصب آسان می توانید تنظیمات اولیه و مورد نیاز قالب وودمارت را انجام داده و دموی مورد نظرتان را درون ریزی کنید. سپس می توانید هر بخشی از قالب و سایت تان را سفارشی سازی کرده و تغییر دهید.',
			'woodmart'
		);
		?>
	</p>

	<p>
		<?php
		esc_html_e(
			'مراحل بعد را مرور کرده و اجرا کنید تا سایت شما آماده شود. در صورتی که سوالی داشتید می توانید با ما در ایران وودمارت تماس گرفته و پشتیبانی دریافت کنید.',
			'woodmart'
		);
		?>
	</p>

	<p class="xts-wizard-signature">
		<span>
			<?php esc_html_e( 'موفق باشید!', 'woodmart' ); ?>
		</span>

		<img src="<?php echo esc_url( $this->get_image_url( 'iranwoodmart.png' ) ); ?>" alt="signature">
	</p>

	<div class="xts-wizard-buttons">
		<a class="xts-inline-btn xts-btn-underline" href="<?php echo esc_url( admin_url( 'admin.php?page=woodmart_dashboard&tab=home&skip_setup' ) ); ?>">
			<?php esc_html_e( 'Skip setup', 'woodmart' ); ?>
		</a>

		<a class="xts-btn xts-btn-alt xts-next" href="<?php echo esc_url( $this->get_page_url( 'activation' ) ); ?>">
			<?php esc_html_e( 'Let\'s start', 'woodmart' ); ?>
		</a>
	</div>

</div>
